#ifndef ATOMS_INTHASH_H
#define ATOMS_INTHASH_H

#include <atoms/object.h>
#include <atoms/text.h>
#include <atoms/array.h>

/*! \brief Хеш ключом которого выступает int64. Работает намного быстрее object.
 *  \ingroup atoms
 */
class IntHash: public Object {
public:
	IntHash();
	virtual ~IntHash();

	virtual Object *get(int64 k);
	virtual void put(int64 k,Object *v);
	virtual void del(int64 k);
	virtual bool exist(int64 k);
	virtual void insert(int32 pos,int64 k,Object *v);
	virtual void get_pos(int64 k,int32 &pos,bool &exist);
	virtual Array *get_keys();
	virtual Array *get_values();
	virtual void empty();

	virtual void print_keys();	
	virtual const char *classname();
	
	int64 *keys;
	Object **values;
	
	int32 size;
	int32 size_real;
};

#endif

