#ifndef SOCKET_H
#define SOCKET_H

#include <atoms/blob.h>

/*! \brief Абстрактный сокет, наследуется TCP и UNIX
 *  \ingroup atoms
 */
class Socket: public Object {
	public:
		Socket();
		virtual ~Socket();
		
		virtual bool send(Blob *b,int32 flags=0);
		virtual bool send(const uint8 *data,uint32 size,int32 flags=0);
		virtual bool send(const char *data,uint32 size,int32 flags=0);
		virtual bool send(const char *data);

		virtual void close();
		virtual Blob *recv(uint32 maxsize=800,uint32 flags=0);
		
		virtual int get_fd();
		virtual int get_fd_or_old();
		virtual Socket *accept()=0;

		virtual bool connected();		
		int fd;
		uint8 tmp[800];
	protected:
		int old_fd;
};

#endif

