#ifndef SOCKET_TCP_H
#define SOCKET_TCP_H

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <atoms/socket.h>

/*! \brief TCP-сокет.
 *  \ingroup atoms
 */
class SocketTcp: public Socket {
	public:
		SocketTcp();
		virtual ~SocketTcp();
	
		virtual const char *classname();
		virtual bool connect(const char *hostname,uint16 port);
		virtual bool listen(const char *hostname,uint16 port,uint16 queue_size=5);
		
		virtual void close(void);
		virtual Socket *accept();
	
		struct sockaddr_in addr;
		socklen_t addrlen;
};

#endif

