#ifndef ATOMS_TEXT_H
#define ATOMS_TEXT_H

#include <atoms/object.h>
#include <atoms/int64.h>
#include <atoms/number.h>
#include <stdio.h>

class Array;
class Text8;
class Text32;
class Blob;
class File;
/*! \brief Абстрактный класс строки. От него унаследованы Text32 и Text8, хранящие UTF32 и UTF8.
 *  \ingroup atoms
 */
class Text: public Object {
public:
	Text();
	Text(Text*txt);
	virtual void init_from_text8 (Text8 *txt);
	virtual void init_from_text32(Text32 *txt);
	virtual void init_from_blob  (Blob *txt);
	virtual Text *concat(Text *txt)=0;
	virtual void add(Text *txt)=0;
	virtual void add(const char *txt)=0;
	virtual void add_bytes(const uint8* buf, uint32 len)=0;
	virtual char *get_chars()=0;
	virtual Int64 *to_int64();
	virtual Number *to_number();
	virtual uint32 get_char(uint32 pos)=0;
	virtual int32 index_of(Text *substr,uint32 pos=0)=0;
	virtual Array *split(Text *substr)=0;
	virtual Text *substr(uint32 start,uint32 len)=0;
	virtual bool starts_with(Text *substr)=0;
	virtual void print()=0;
	virtual void print(FILE *out)=0;

	/*! \brief Возвращает размер строки в символах.
	 *  \param text Исходная строка.
	 *  \param maxsize Размер исходной строки в байтах
	 */
	static uint32 calc_length(const uint8 *text,uint32 maxsize);
	
	/*! \brief Возвращает размер строки в символах.
	 *  \param text Исходная строка, заканчивающаяся \0.
	 */
	static uint32 calc_length(const char *text);

	virtual char *ptr()=0;
	virtual uint32 size_in_bytes()=0;

	static uint32 calc_size_bytes(const uint32 *text,uint32 maxlength);
	static void copy_utf8_to_utf32(const uint8 *src,uint32 *dst,uint32 length);
	static void copy_utf32_to_utf8(const uint32 *src,uint8 *dst,uint32 length);
	uint32 length;
protected:
};

#endif
