#include <atoms/array.h>
#include <atoms/blob.h>

/*****************************************************************************/
Array::Array()
{
	size=0;
	size_real=10;
	array=(Object**)malloc(sizeof(Object*)*size_real);
	uint32 i;
	for (i=0;i!=size_real;i++) array[i]=NULL;
}

/*****************************************************************************/
Array::~Array()
{
	uint32 i;
	for (i=0;i!=size;i++) {
		if (array[i]) array[i]->del_ref();
	}
	free(array);
}

/*****************************************************************************/
const char *Array::classname()
{
	return "Array";
}

/*****************************************************************************/
void Array::empty()
{
	uint32 i;
	for (i=0;i<size;i++) {
		if (array[i]) array[i]->del_ref();
	}
	size=0;
}
/*****************************************************************************/
void Array::grow(uint32 _size)
{
	if (_size<=size_real) return;
	size_real=_size;
	Object **tmp=array;
	array=(Object**)malloc(sizeof(Object*)*size_real);
	memmove(array,tmp,sizeof(Object*)*size);
	free(tmp);
}

/*****************************************************************************/
void Array::add(Array *a)
{
	if (!a) return;
	if (a->size==0) return;
	grow(size+a->size);
	memmove(array+sizeof(Object*)*size,a->array,sizeof(Object*)*a->size);
	for (uint32 i=size;i<size+a->size;i++) {
		if (array[i]) array[i]->add_ref();
	}
	size+=a->size;
}

/*****************************************************************************/
void Array::put(uint32 i,Object *o)
{
	if (i>=size) {
		grow(i+1);
		while (size<=i) {
			array[size]=NULL;
			size++;
		}
	}
	if (array[i]) array[i]->del_ref();
	array[i]=o;
	if (o) o->add_ref();
}

/*****************************************************************************/
Object *Array::get(uint32 i)
{
	if (i>=size) return NULL;
	return array[i];
}

/*****************************************************************************/
void Array::push(Object *o)
{
	put(size,o);
}

/*****************************************************************************/
void Array::del(uint32 pos)
{
	if (pos>=size) return;
	if (array[pos]) array[pos]->del_ref();
	size--;
	uint32 i;
	for (i=pos;i!=size;i++) {
		array[i]=array[i-1];
	}
}

/*****************************************************************************/
void Array::del(Object *o)
{
	uint32 i=0;
	uint32 i2=0;
	while (i<size) {
		if (i2!=0) {
			array[i]=array[i+i2];
		}
		if (array[i]==o) {
			if (o) o->del_ref();
			size--;
			i2++;
		} else {
			i++;
		}
	}
}

/*****************************************************************************/
Object *Array::pop()
{
	if (!size) return NULL;
	Object *o=array[size-1];
	size--;
	o->cnt_refs--;
	return o;
}

/*****************************************************************************/
bool Array::storable_to_blob(Blob *b)
{
	b->add_bytes((const uint8*)(&size),4);
	b->word_align();
	for (uint32 i=0;i<size;i++) {
		if (array[i]->storable_to_blob(b)) return true;
	}
	return false;
}

/*****************************************************************************/

