#include <atoms/double.h>
#include <atoms/blob.h>

/*****************************************************************************/
Double::Double()
{
	value=0;
}

/*****************************************************************************/
Double::Double(double v)
{
	value=v;
}

/*****************************************************************************/
Double::~Double()
{

}

/*****************************************************************************/
const char *Double::classname(void)
{
	return "Double";
}

/*****************************************************************************/
int8 Double::cmp(Object *c)
{
	Double *c1=dynamic_cast<Double*>(c);
	if (c1) {
		if (c1->value==value) return 0;
		return (value<c1->value)?-1:1;
	} else {
		return Object::cmp(c);
	}
}

/*****************************************************************************/
bool Double::storable_to_blob(Blob *b)
{
	b->add_bytes((const uint8*)(&value),sizeof(double));
	b->word_align();
	return false;
}

/*****************************************************************************/

