#include <stdio.h>
#include <atoms/text.h>
#include <atoms/text8.h>
#include <atoms/text32.h>
#include <atoms/blob.h>

/*****************************************************************************/
Text::Text()
{

}

/*****************************************************************************/
Text::Text(Text*txt)
{
	if (dynamic_cast<Text8*>(txt)) {
		init_from_text8(dynamic_cast<Text8*>(txt));
	} else if (dynamic_cast<Text32*>(txt)) {
		init_from_text32(dynamic_cast<Text32*>(txt));
	} else if (dynamic_cast<Blob*>(txt)) {
		init_from_blob(dynamic_cast<Blob*>(txt));
	}
}

/*****************************************************************************/
void Text::copy_utf8_to_utf32(const uint8 *src,uint32 *dst,uint32 length)
{
	uint32 pos1=0;
	uint32 pos2=0;
	uint32 r;
	while (pos2!=length) {
		if ((src[pos1]&010000000)==0) {
			r=src[pos1];pos1++;
		} else if ((src[pos1]&011100000)==011000000) {
			r=(src[pos1]&000011111)<<6+src[pos1+1]&000111111;pos1+=2;
		} else if ((src[pos1]&011110000)==011100000) {
			r=(src[pos1]&000001111)<<12+(src[pos1+1]&000111111)<<6+src[pos1+2]&000111111;pos1+=3;
		} else if ((src[pos1]&011111000)==011110000) {
			r=(src[pos1]&000000111)<<18+(src[pos1+1]&000111111)<<12+(src[pos1+2]&000111111)<<6+src[pos1+3]&000111111;pos1+=4;
		} else if ((src[pos1]&011111100)==011111000) {
			r=(src[pos1]&000000011)<<24+(src[pos1+1]&000111111)<<18+(src[pos1+2]&000111111)<<12+(src[pos1+3]&000111111)<<6+src[pos1+4]&000111111;pos1+=5;
		} else if ((src[pos1]&011111110)==011111100) {
			r=(src[pos1]&000000001)<<30+(src[pos1+1]&000111111)<<24+(src[pos1+2]&000111111)<<18+(src[pos1+3]&000111111)<<12+(src[pos1+4]&000111111)<<6+src[pos1+5]&000111111;pos1+=6;
		}
		dst[pos2]=r;
		pos2++;
	}
}

/*****************************************************************************/
void Text::copy_utf32_to_utf8(const uint32 *src,uint8 *dst,uint32 length)
{
	uint32 pos1=0;
	uint32 pos2=0;
	uint32 r;
	while (pos1!=length) {
		r=src[pos1];
		       if (r<=0x0000007F) {
			dst[pos2]=r;
			pos2++;
		} else if (r<=0x000007FF) {
			dst[pos2  ]=011000000+(r>>6);
			dst[pos2+1]=010000000+(r&000111111);
			pos2+=2;
		} else if (r<=0x0000FFFF) {
			dst[pos2  ]=011100000+(r>>12);
			dst[pos2+1]=010000000+((r>>6)&000111111);
			dst[pos2+2]=010000000+(r&000111111);
			pos2+=3;
		} else if (r<=0x001FFFFF) {
			dst[pos2  ]=011110000+(r>>18);
			dst[pos2+1]=010000000+((r>>12)&000111111);
			dst[pos2+2]=010000000+((r>>6)&000111111);
			dst[pos2+3]=010000000+(r&000111111);
			pos2+=4;
		} else if (r<=0x03FFFFFF) {
			dst[pos2  ]=011111000+(r>>24);
			dst[pos2+1]=010000000+((r>>18)&000111111);
			dst[pos2+2]=010000000+((r>>12)&000111111);
			dst[pos2+3]=010000000+((r>>6)&000111111);
			dst[pos2+4]=010000000+(r&000111111);
			pos2+=5;
		} else if (r<=0x7FFFFFFF) {
			dst[pos2  ]=011111100+(r>>30);
			dst[pos2+1]=010000000+((r>>24)&000111111);
			dst[pos2+2]=010000000+((r>>18)&000111111);
			dst[pos2+3]=010000000+((r>>12)&000111111);
			dst[pos2+4]=010000000+((r>>6)&000111111);
			dst[pos2+5]=010000000+(r&000111111);
			pos2+=6;
		}
		pos1++;
	}
}

/*****************************************************************************/
uint32 Text::calc_length(const uint8 *text,uint32 maxsize)
{
	uint32 length=0;
	uint32 i=0;
	while (i<maxsize) {
		if (text[i]<010000000) {
			i++;length++;
		} else if (text[i]<011100000) {
			i+=2;length++;
		} else if (text[i]<011110000) {
			i+=3;length++;
		} else if (text[i]<011111000) {
			i+=4;length++;
		} else if (text[i]<011111100) {
			i+=5;length++;
		} else if (text[i]<011111110) {
			i+=6;length++;
		} else {
			i++;
		}
	}
	return length;
}

/*****************************************************************************/
uint32 Text::calc_length(const char *text)
{
	uint32 length=0;
	uint32 i=0;
	while (text[i]!=0) {
		if (text[i]<010000000) {
			i++;length++;
		} else if (text[i]<011100000) {
			i+=2;length++;
		} else if (text[i]<011110000) {
			i+=3;length++;
		} else if (text[i]<011111000) {
			i+=4;length++;
		} else if (text[i]<011111100) {
			i+=5;length++;
		} else if (text[i]<011111110) {
			i+=6;length++;
		} else {
			i++;
		}
	}
	return length;
}

/*****************************************************************************/
uint32 Text::calc_size_bytes(const uint32 *text,uint32 maxlength)
{
	uint32 size=0;
	uint32 i=0;
	while (i<maxlength) {
		       if (text[i]<=0x0000007F) {
			size++;
		} else if (text[i]<=0x000007FF) {
			size+=2;
		} else if (text[i]<=0x0000FFFF) {
			size+=3;
		} else if (text[i]<=0x001FFFFF) {
			size+=4;
		} else if (text[i]<=0x03FFFFFF) {
			size+=5;
		} else if (text[i]<=0x7FFFFFFF) {
			size+=6;
		}
		i++;
	}
	return size;
}

/*****************************************************************************/
Int64 *Text::to_int64()
{
	int64 i=0;
	uint32 pos=0;
	int8 sign=1;
	while (pos<length) {
		uint32 c=get_char(pos);pos++;
		if (c=='-' && pos==1) {
			sign=-1;
		} else if (c=='+' && pos==1) {
			sign=1;
		} else if (c>='0' && c<='9') {
			i*=10;
			i+=c-'0';
		} else {
			pos=length;
		}
	}
	return new Int64(i*sign);
}

/*****************************************************************************/
Number *Text::to_number()
{
	int64 i=0;
	uint32 pos=0;
	int8 sign=1;
	uint8 prec=0;
	uint8 size=30;
	while (pos<length) {
		uint32 c=get_char(pos);pos++;
		if (c=='-' && pos==1) {
			sign=-1;
		} else if (c=='+' && pos==1) {
			sign=1;
		} else if (c>='0' && c<='9') {
			i*=10;
			i+=c-'0';
		} else {
			pos=length;
		}
	}
	return new Number(size,prec,i*sign);
}

/*****************************************************************************/
void Text::init_from_text8 (Text8 *txt)
{
	assert(0);
}

/*****************************************************************************/
void Text::init_from_text32(Text32 *txt)
{
	assert(0);
}

/*****************************************************************************/
void Text::init_from_blob  (Blob *txt)
{
	assert(0);
}

/*****************************************************************************/

