#include <stdio.h>
#include <atoms/text32.h>
#include <atoms/text8.h>
#include <atoms/blob.h>
#include <atoms/array.h>
#include <atoms/funcs.h>

uint32 zero_ptr_uint32[1]={0};

/*****************************************************************************/
Text32::Text32()
{
	length=0;
	text=zero_ptr_uint32;
}

/*****************************************************************************/
Text32::Text32(Text *txt): Text()
{
	text=zero_ptr_uint32;
	length=0;
	if (dynamic_cast<Text8*>(txt)) {
		init_from_text8(dynamic_cast<Text8*>(txt));
	} else if (dynamic_cast<Text32*>(txt)) {
		init_from_text32(dynamic_cast<Text32*>(txt));
	} else if (dynamic_cast<Blob*>(txt)) {
		init_from_blob(dynamic_cast<Blob*>(txt));
	}

}

/*****************************************************************************/
Text32::Text32(const char *chr)
{
	length=calc_length(chr);
	if (length) {
		text=(uint32*)malloc(sizeof(uint32)*(length+1));
		// TODO: char!=uint8
		copy_utf8_to_utf32((uint8*)chr,text,length);
		text[length]=0;
	} else {
		text=zero_ptr_uint32;
	}
}

/*****************************************************************************/
Text32::Text32(const char *chr,uint32 _size_bytes)
{
	length=calc_length((uint8*)chr,_size_bytes);
	if (length) {
		text=(uint32*)malloc(sizeof(uint32)*(length+1));
		text[length]=0;
		copy_utf8_to_utf32((uint8*)chr,text,length);
	} else {
		text=zero_ptr_uint32;
	}
}

/*****************************************************************************/
Text32::Text32(uint32 *txt,uint32 len)
{
	text=zero_ptr_uint32;
	length=len;
	if (length) {
		text=(uint32*)malloc(sizeof(uint32)*(length+1));
		memmove(text,txt,sizeof(uint32)*length);
		text[length]=0;
	}
}

/*****************************************************************************/
Text32::~Text32()
{
	if (length) free(text);
}

/*****************************************************************************/
void Text32::init_from_text32(Text32 *txt)
{
	length=txt->length;
	if (length) {
		text=(uint32*)malloc(sizeof(uint32)*(length+1));
		memmove(text,txt->text,sizeof(uint32)*length);
		text[length]=0;
	} else {
		text=zero_ptr_uint32;
	}
}

/*****************************************************************************/
void Text32::init_from_text8(Text8 *txt)
{
	if (length) free(text);
	length=txt->length;
	if (length) {
		text=(uint32*)malloc(sizeof(uint32)*(length+1));
		copy_utf8_to_utf32(txt->text,text,length);
		text[length]=0;
	} else {
		text=zero_ptr_uint32;
	}
}

/*****************************************************************************/
void Text32::init_from_blob(Blob *txt)
{
	assert(0);
}

/*****************************************************************************/
Text *Text32::concat(Text *txt1)
{
	Text32 *r=new Text32(this);
	r->add(txt1);
	return r;
}

/*****************************************************************************/
void Text32::add(const char *txt1)
{
	if (txt1==NULL) return;
	Text32 *t=new Text32(txt1);
	t->add_ref();
	add(t);
	t->del_ref();
}

/*****************************************************************************/
void Text32::add_bytes(const uint8 *buf,uint32 len)
{
	len^=(len&3);
	if (len==0) return;
	uint32 *tmp=text;
	text=(uint32*)malloc(sizeof(uint32)*(length+(len>>2)+1));
	memmove(text,tmp,sizeof(uint32)*length);
	if (length) free(tmp);

	memmove(text+length,buf,len);
	length+=len>>2;
	text[length]=0;
}


/*****************************************************************************/
void Text32::add(Text *txt1)
{
	if (txt1==NULL) return;
	Text32 *txt=text_to_text32(txt1);
	txt->add_ref();
	uint32 *tmp=text;
	text=(uint32*)malloc(sizeof(uint32)*(length+txt->length+1));
	memmove(text,tmp,sizeof(uint32)*length);
	if (length) free(tmp);

	memmove(text+length,txt->text,sizeof(uint32)*txt->length);
	length+=txt->length;
	text[length]=0;

	txt->del_ref();
}

/*****************************************************************************/
Text *Text32::substr(uint32 start,uint32 len)
{
	if (start>=length) {
		return new Text32();
	}
	if (start+len>=length) {
		len=length-start;
	}
	return new Text32(text+start,len);
}

/*****************************************************************************/
const char *Text32::classname()
{
	return "Text32";
}

/*****************************************************************************/
int8 Text32::cmp(Object *txt1)
{
	if (txt1==this) return 0;
	Text32 *txt=dynamic_cast<Text32*>(txt1);
	bool del=false;
	if (txt==NULL) {
		Text *tmp=dynamic_cast<Text*>(txt1);
		if (!tmp) return Object::cmp(txt1);
		txt=new Text32(tmp);
		txt->add_ref();
		del=true;
	}
	int8 rv=memcmp2((uint8*)text,length*sizeof(uint32),(uint8*)txt->text,txt->length*sizeof(uint32));
	if (del) txt->del_ref();
	return rv;
}

/*****************************************************************************/
char *Text32::get_chars()
{
	uint32 si=calc_size_bytes(text,length);
	char *s=(char*)malloc(sizeof(char)*(si+1));
	// TODO if uint8!=char
	// TODO: national
	copy_utf32_to_utf8(text,(uint8*)s,length);
	s[si]=0;
	return s;
}

/*****************************************************************************/
uint32 Text32::get_char(uint32 pos)
{
	if (pos>=length) return (uint32)-1;
	return text[pos];
}

/*****************************************************************************/
int32 Text32::index_of(Text *txt1,uint32 pos)
{
	Text32 *txt=text_to_text32(txt1);
	txt->add_ref();
	int32 rv=-1;
	uint32 offset=pos<<2;
	uint32 s=txt->length<<2;
	while (length-pos>=txt->length && rv==-1) {
		if (memcmp(text+offset,txt->text,s)==0) {
			rv=pos;
		} else {
			pos++;
			offset+=4;
		}
	}
	txt->del_ref();
	return rv;
}

/*****************************************************************************/
Array *Text32::split(Text *txt1)
{
	Text32 *txt=text_to_text32(txt1);
	txt->add_ref();
	uint32 prevpos=0;
	uint32 pos=0;
	Array *a=new Array();
	while (length-pos>=txt->length) {
		if (memcmp(text+(pos<<2),txt->text,txt->length<<2)==0) {
			a->push(new Text32((uint32*)(text+(prevpos<<2)),pos-prevpos));
			pos+=txt->length;
			prevpos=pos;
		} else {
			pos++;
		}
	}
	a->push(new Text32((uint32*)(text+(prevpos<<2)),length-prevpos));
	txt->del_ref();
	return a;
}

/*****************************************************************************/
bool Text32::starts_with(Text *txt1)
{
	Text32 *txt=text_to_text32(txt1);
	txt->add_ref();
	bool flag=false;
	if (txt->length<=length) {
		flag=memcmp(text,txt->text,txt->length*sizeof(uint32))?false:true;
	}
	txt->del_ref();
	return flag;
}

/*****************************************************************************/
char *Text32::ptr()
{
	return (char*)text;
}

/*****************************************************************************/
uint32 Text32::size_in_bytes()
{
	return length*4;
}
/*****************************************************************************/
void Text32::print()
{
	char *c=get_chars();
	printf("%s",c);
	free(c);
}

/*****************************************************************************/
void Text32::print(FILE *out)
{
	char *c=get_chars();
	fprintf(out,"%s",c);
	free(c);
}

/*****************************************************************************/
bool Text32::storable_to_blob(Blob *b)
{
	uint32 sb=size_in_bytes();
	b->add_bytes((const uint8*)(&sb),4);
	b->add_bytes((const uint8*)text,sb);
	b->word_align();
	return false;
}

/*****************************************************************************/

