#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "offermon/memcache.h"

/**
 * Method: Banner::new
 */
Banner::Banner()
{
	do_free=false;

}

/**
 * Method: Banner::delete
 */
Banner::~Banner()
{
	if (do_free) {
		free(image_url);
		free(logo_url);
		free(name);
		free(description);
	}
}

/**
 * Method: Banner::load
 */
bool Banner::load(ReadStream *s)
{
	int32 i;
	do_free=false;
	id			=s->read_int64();
	offer_id	=s->read_int64();
	type_id		=s->read_int64();
	logo_url	=s->read_charptr();
	image_url	=s->read_charptr();
	name		=s->read_charptr();
	description	=s->read_charptr();
}

/**
 * Method: Banner::save
 */
bool Banner::save(WriteStream *s)
{
	int i;
	do_free=false;
	s->write_int64(id);
	s->write_int64(offer_id);
	s->write_int64(type_id);
	s->write_charptr(logo_url);
	s->write_charptr(image_url);
	s->write_charptr(name);
	s->write_charptr(description);
}

/**
 * Method: Banner::load
 */
bool Banner::load(PGresult *res,int row)
{
	do_free=true;
	id					=atol(  PQgetvalue(res,row,0));
	offer_id			=atol(  PQgetvalue(res,row,1));
	type_id				=atol(  PQgetvalue(res,row,2));
	logo_url			=strdup(PQgetvalue(res,row,3));
	image_url			=strdup(PQgetvalue(res,row,4));
	name				=strdup(PQgetvalue(res,row,5));
	description			=strdup(PQgetvalue(res,row,6));
}

const char *Banner::classname(void) { return "Banner"; };


