#ifndef ATOMS_OBJECT_H
#define ATOMS_OBJECT_H

#include <_types_.h>


class Text8;
class Blob;

/*! \brief Базовый класс иерархии.
 *  \ingroup atoms
 *
 * Любой класс в данной объектной модели должен быть унаследован от него.
 * Хранит количество ссылок на себя, и автоматически удаляется при количестве ссылок==0.
 * Контроль количества ссылок - вручную, то есть каждый раз необходимо делать add_ref()/del_ref().
 * Все базовые классы (array, hash, ..) делают это автоматически для своих элементов.
 */
class Object {
public:
	Object();
//	Object(uint8 *src,uint32 len,uint32 &posinc,uint8 &error);
//	Object(Text8 *src,uint32 &posinc,uint8 &error);
	virtual ~Object();


//	virtual void to_blob_iter(Blob *b,uint8 &error);
//	virtual void to_json_iter(Text8 *t,uint8 &error);

	/*! \brief Увеличивает количество ссылок на единицу.
	 */
	virtual void add_ref(void);
	
	/*! \brief Уменьшает количество ссылок на единицу, вызывая деструктор при nrefs==0.
	 */
	virtual void del_ref(void);
	
	/*! \brief Уменьшает количество ссылок на единицу, НО НЕ вызывает деструктор при nrefs==0.
	 */
	virtual void del_ref_only(void);

	/*! \brief Абстрактный метод, возвращает строку содержащую имя класса. Очень полезно для отладки */
	virtual const char *classname()=0;

	/*! \brief Сравнение двух объектов. Возможны изощерённые глюки.
	 *
	 *  По-умолчанию, сравнение двух объектов ведётся на равенство их указателей, то есть "Это действительно тот же самый объект".
	 *  В классах text8, text32, int64, number, boolean и тд - метод переопределён.
	 *  Стоит понимать что сравнение двух объектов _разных_ классов может быть не транзитивным.
	 */
	virtual int8 cmp(Object *c);

	virtual bool storable_to_blob(Blob *b);	
	/*! \brief Количество ссылок
	 */
	int32 cnt_refs;

};

#endif
