#ifndef SELECT_H
#define SELECT_H

#include <atoms/socket.h>

/*! /brief Обёртка вокруг select, работающего с сокетами. can_read() Может возвращать NULL.
 *  /ingroup atoms
 *  
 */
class Select: public Object {
	public:
		Select();
		virtual ~Select();

		virtual const char *classname();
		virtual void add(Socket *s);
		virtual void del(Socket *s);

		/*! /brief Возвращает сокеты готовые к чтению.
		 *  /param timeout Тайм-аут в секундах.
		 *  /return Массив сокетов или (!)NULL в случае если никто не готов.
		 */
		virtual Array *can_read(double timeout=0);

		Array *sockets;
};

#endif

