#include <atoms/funcs.h>
#include <atoms/text8.h>
#include <atoms/text32.h>
#include <atoms/blob.h>

/*****************************************************************************/
void add_ref(Object *o)
{
	if (o!=NULL) o->cnt_refs++;
}

/*****************************************************************************/
void del_ref(Object *&o)
{
	if (o==NULL) return;
	o->cnt_refs--;
	if (o->cnt_refs==0) {
		delete o;
		o=NULL;
	}
}

/*****************************************************************************/
int8 memcmp2(uint8 *data1,uint32 size1,uint8 *data2,uint32 size2)
{
	uint32 size=(size1<size2)?size1:size2;
	int i=memcmp(data1,data2,size);
/*	printf("memcmp2 i=%d (size=%d)\n\n",i,size);
	int j;
	for (j=0;j<size1;j++) printf(" %d",data1[j]);printf("\n");
	for (j=0;j<size2;j++) printf(" %d",data2[j]);printf("\n");
	printf("\n");*/

	if (i) return (i<0)?-1:1;
	if (size1!=size2) {
		return size1<size2?-1:1;
	}
	return 0;
}

/*****************************************************************************/
Blob *text_to_blob(Text *t)
{
	Blob *a=dynamic_cast<Blob*>(t);
	if (a) return a;
	return new Blob(t);
}

/*****************************************************************************/
Text8 *text_to_text8(Text *t)
{
	Text8 *a=dynamic_cast<Text8*>(t);
	if (a) return a;
	return new Text8(t);
}

/*****************************************************************************/
Text32 *text_to_text32(Text *t)
{
	Text32 *a=dynamic_cast<Text32*>(t);
	if (a) return a;
	return new Text32(t);
}

/*****************************************************************************/
