#include <atoms/number.h>

Number::Number(uint8 _size,uint8 _prec,double _v)
{
	size=_size;
	prec=_prec;
	value=_v;
}

Number *Number::clone()
{
	return new Number(size,prec,value);
}

Number::~Number()
{

}

const char *Number::classname(void)
{
	return "Number";
}

int8 Number::cmp(Object *c)
{
	Number *c1=dynamic_cast<Number*>(c);
	if (c1) {
		if (c1->value==value) return 0;
		return (value<c1->value)?-1:1;
	} else {
		return Object::cmp(c);
	}
}

