#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <evhttp.h>

#include "offermon/writer.h"
#include "offermon/memcache.h"
#include "offermon/tracker_static.h"
#include "offermon/tracker.h"
#include "offermon/scan_struct.h"

TrackerStatic *ts;
const char *DEMO_UA_ANDROID="Mozilla/5.0 (Linux; Android 4.4; Nexus 5 Build/_BuildID_) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36";
const char *DEMO_IP_GERMANY="46.4.59.135";
const char *DEMO_IP_USA="8.8.8.8";
const int64 DEMO_OFFER_ID=520293;
const char *DEMO_FCLICKID="322223";
int quit=0;
int ts_needs_update=0;

struct event_base *base = NULL;

/**
 * Function: test
 */
void test()
{
	printf("main()\n");
	printf("main() - writers_init()\n");
	writers_init();
	
	
	printf("main() - ts->memcache_from_db()\n");
	ts->memcache_from_db();
	
	printf("main() - ts->memcache_to_file()\n");
	ts->memcache_to_file();


	int selections[][4]={{0,1,0,0},{0,0,0,0},{20,2,1,100},{25,1,1,150},{30,2,1,220},{30,3,1,350},{-1,-1,-1,-1}};
	char tmp[100];
	Tracker *tr;

/*	tr=new Tracker(ts);
	tr->tmpstr_set("http://www.offermon.com/www/hello/www/world/test/string/");
	printf("STEP 0: '%s'\n",tr->tmpstr);
	tr->tmpstr_replace("www.","");
	printf("STEP 1: '%s'\n",tr->tmpstr);
	tr->tmpstr_replace("/www",NULL);
	printf("STEP 2: '%s'\n",tr->tmpstr);
	tr->tmpstr_replace("offermon","o-f-f-e-r-m-o-n");
	printf("STEP 3: '%s'\n",tr->tmpstr);
	tr->tmpstr_replace("hello","hlo");
	printf("STEP 4: '%s'\n",tr->tmpstr);
	exit(0);*/

	int i;
	int debug;
	for (i=0;i<900;i++) {
		debug=i<2;
		if (i<2 || i%50==0) printf("test() - creating Tracker(%d)\n",i);
		tr=new Tracker();

		if (debug) printf("test() - tr->init()\n");
		tr->init(MODE_INDEX,DEMO_IP_GERMANY,DEMO_UA_ANDROID,DEMO_OFFER_ID,9,DEMO_FCLICKID);

		if (debug) printf("test() - tr->parse()\n");
		tr->parse();

		if (debug) tr->dump();

		if (debug) printf("test() - tr->work()\n");
		tr->work();

		if (debug) printf("test() - tr->evbuffer_dump()\n");
		if (debug) tr->evbuffer_dump();

		if (debug) printf("test() - delete tr\n");
		delete tr;

		if (debug) printf("\n\n");
	}

	for (int i=0;selections[i][0]!=-1;i++) {
		if (selections[i][3]==0) continue;
		sprintf(tmp,"%d_%d_%d",selections[i][0],selections[i][1],selections[i][2]);
		printf("test() - making postback on file %s\n",tmp);
		tr=new Tracker();
		tr->init(MODE_POSTBACK,DEMO_IP_USA,DEMO_UA_ANDROID,0,0,NULL,tmp,0,0,0.01*selections[i][3]);
		tr->parse();
		tr->work();
		delete tr;
	}
	for (int i=0;selections[i][0]!=-1;i++) {
		sprintf(tmp,"%d_%d_%d",selections[i][0],selections[i][1],selections[i][2]);
		printf("test() - loading %s\n",tmp);
		Writer *wr=writer_get(selections[i][1]);
		tr=wr->read_message(selections[i][0]);
		if (tr) {
			tr->dump();
			delete tr;
		}
	}


	printf("main() - delete ts\n");
	delete ts;

	printf("main() - writers_stop()\n");
	writers_stop();
}

/**
 * Function: on_request
 */
void on_request(evhttp_request *req, void *)
{
	if (quit) return;
	Tracker *tr;
	tr=new Tracker();
	tr->init(req);
	if (ts->memcache) {
		tr->parse();
		tr->work();
	} else {
		tr->work__error("memcache is still loading");
	}
	tr->evbuffer_send();
	delete tr;
	if (quit) event_base_loopexit(base,NULL);
	if (ts_needs_update) {
		ts->memcache_from_db();
		ts_needs_update=0;
	}
}

/**
 * Function: server
 */
int server(int portno)
{
	printf("main()\n");

	printf("event_base_new()\n");
	base = event_base_new();
	if (base == NULL) return -1;

	printf("main() - writers_init()\n");
	writers_init();
	
	printf("main() - ts->memcache_from_db()\n");
	ts->memcache_from_db();

	printf("main() - READY\n");
	struct evhttp *httpd = NULL;

	httpd = evhttp_new(base);
	if (httpd == NULL) return -1;
	if (evhttp_bind_socket(httpd, "0.0.0.0", portno) != 0) return -1;
	evhttp_set_gencb(httpd, on_request, NULL);
	event_base_dispatch(base);


	printf("main() - delete ts\n");
	delete ts;

	printf("main() - writers_stop()\n");
	writers_stop();

	return 0;
}

/**
 * Function: fileops_parse_args
 */
ScanStruct *fileops_parse_args(int start_argno,int argc,char **argv,const char *default_columns)
{
	ScanStruct *ss=new ScanStruct();
	int i=start_argno;
	ss->columns_init(default_columns);
	while (i<argc) {
		if (strcmp(argv[i],"--columns")==0) {
			ss->columns_init(argv[i+1]);
			i+=2;
		} else {
			fprintf(stderr,"Unknown argument %s\n",argv[i]);
			exit(1);
		}
	}
	return ss;
}

/**
 * Function: file_scan
 */
void file_scan(int fileno,int argc,char **argv)
{
	ScanStruct *ss=fileops_parse_args(4,argc,argv,NULL);
	ss->print_headers();printf("\n");
	scanner(fileno,ss,file_scan_on_each_row);
	delete ss;
}

/**
 * Function: file_stat
 */
void file_stat(int fileno,int argc,char **argv)
{
	ScanStruct *ss=fileops_parse_args(4,argc,argv,"click_dateonly,offer_id,user_id,device_id,region_id");
	ss->stats_init();
	scanner(fileno,ss,file_stat_on_each_row);
	ss->stats_dump();
	delete ss;
}

/**
 * Function: file_dumpone
 */
void file_dumpone(int fileno,int entryno)
{
	Tracker *tr=new Tracker();
	tr->init();
	Writer *wr=writer_get(fileno);
	if (wr->read_message(entryno,tr)!=NULL) {
		tr->dump();
	}
	delete tr;
}

/**
 * Function: main
 */
int main(int argc,char **argv)
{
	ts_needs_update=0;
	if (argc<3) {
		printf("Usage:\n");
		printf("%s test NODENO                                          - Run system self-tests\n",argv[0]);
		printf("%s server NODENO PORTNO                                 - Run server on 0.0.0.0:PORTNO\n",argv[0]);
		printf("%s scan NODENO FILENO [--columns colnames] [filters]    - Scan file and dump output to stdout\n",argv[0]);
		printf("%s stat NODENO FILENO [--columns colnames] [filters]    - Scan file and dump stats to stdout\n",argv[0]);
		printf("%s dumpone NODENO FILENO ENTRYNO                        - Scan file and dump one entry stdout\n",argv[0]);
		printf("%s genblob NAME                                         - Scan file and dump output to stdout\n",argv[0]);
		exit(0);
	}
	ts=new TrackerStatic();
	ts->db_connect();
//	printf("argc=%d, argv[2]=%s\n",argc,argv[2]);

	if (strcmp(argv[1],"scan")==0) {
		NODENO=atoi(argv[2]);
		file_scan(atoi(argv[3]),argc,argv);

	} else if (strcmp(argv[1],"stat")==0) {
		NODENO=atoi(argv[2]);
		file_stat(atoi(argv[3]),argc,argv);

	} else if (strcmp(argv[1],"dumpone")==0) {
		NODENO=atoi(argv[2]);
		file_dumpone(atoi(argv[3]),atoi(argv[4]));

	} else if (strcmp(argv[1],"test")==0) {
//		NODENO=atoi(argv[2]);
//		test();
		fprintf(stderr,"test() is disabled due to change to async DB model\n");

	} else if (strcmp(argv[1],"server")==0) {
		NODENO=atoi(argv[2]);
		if (argc==3) server(8080); else server(atoi(argv[3]));

	} else if (strcmp(argv[1],"genblob")==0) {
		printf("genblob mode TODO\n");

	} else {
		printf("Unknown command '%s'\n",argv[1]);
	}
	return 0;
}

