#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "offermon/memcache.h"

/**
 * Method: DefaultPricing::new
 */
DefaultPricing::DefaultPricing()
{

}

/**
 * Method: DefaultPricing::delete
 */
DefaultPricing::~DefaultPricing()
{

}

/**
 * Method: DefaultPricing::load
 */
bool DefaultPricing::load(ReadStream *s)
{
	id						=s->read_int64();
	cpa_network_id			=s->read_int64();
	min_price				=0.0001*s->read_int32();
	max_price				=0.0001*s->read_int32();
	percent					=0.0001*s->read_int32();
	percent_cpa				=0.0001*s->read_int32();
}

/**
 * Method: DefaultPricing::save
 */
bool DefaultPricing::save(WriteStream *s)
{
	s->write_int64(id);
	s->write_int64(cpa_network_id);
	s->write_int32(10000*min_price);
	s->write_int32(10000*max_price);
	s->write_int32(10000*percent);
	s->write_int32(10000*percent_cpa);
}

/**
 * Method: DefaultPricing::load
 */
bool DefaultPricing::load(PGresult *res,int row)
{
	id						=atol(PQgetvalue(res,row,0));
	cpa_network_id			=atol(PQgetvalue(res,row,1));
	min_price				=atof(PQgetvalue(res,row,2));
	max_price				=atof(PQgetvalue(res,row,3));
	percent					=atof(PQgetvalue(res,row,4));
	percent_cpa				=atof(PQgetvalue(res,row,5));
}

const char *DefaultPricing::classname() { return "DefaultPricing"; }

