#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "offermon/memcache.h"

/**
 * Method: Smartlink::new
 */
Smartlink::Smartlink()
{
	offers=NULL;
	ids=NULL;
}

/**
 * Method: Smartlink::delete
 */
Smartlink::~Smartlink()
{
	if (offers) free(offers);
	if (ids) free(ids);
}

/**
 * Method: Smartlink::load
 */
bool Smartlink::load(ReadStream *s)
{
	int32 i;
	id			=s->read_int64();
	user_id		=s->read_int64();
	length		=s->read_int32();
	offers		=(int64*)malloc(sizeof(int64)*length);
	for (i=0;i<length;i++) offers[i]=s->read_int64();
	ids			=(int64*)malloc(sizeof(int64)*length);
	for (i=0;i<length;i++) ids[i]=s->read_int64();
}

/**
 * Method: Smartlink::save
 */
bool Smartlink::save(WriteStream *s)
{
	int i;
	s->write_int64(id);
	s->write_int64(user_id);
	s->write_int32(length);
	for (i=0;i<length;i++) s->write_int64(offers[i]);
	for (i=0;i<length;i++) s->write_int64(ids[i]);
}

/**
 * Method: Smartlink::load
 */
bool Smartlink::load(PGresult *res,int row)
{
	int i=0;
	int pos=0;
	int len1;
	int len2;
	length=1;
	char *tmp1;
	char *tmp2;
	id					=atol(  PQgetvalue(res,row,0));
	user_id				=atol(  PQgetvalue(res,row,1));
	tmp1				=       PQgetvalue(res,row,2);
	tmp2				=       PQgetvalue(res,row,3);
	len1=strlen(tmp1);
	len2=strlen(tmp2);
	for (i=0;i<len1;i++) if (tmp1[i]==',') length++;
	offers		=(int64*)malloc(sizeof(int64)*length);
	ids			=(int64*)malloc(sizeof(int64)*length);

	pos=0;
	offers[pos]=atol(tmp1);
	pos++;
	for (i=1;i<len1;i++) {
		if(tmp1[i]==',') {
			offers[pos]=atol(tmp1+i+1);
			pos++;
		}
	}
	pos=0;
	ids[pos]=atol(tmp2);
	pos++;
	for (i=1;i<len2;i++) {
		if(tmp2[i]==',') {
			ids[pos]=atol(tmp2+i+1);
			pos++;
		}
	}
}

const char *Smartlink::classname(void) { return "Smartlink"; };


