#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "offermon/memcache.h"
#include "offermon/tracker.h"

#define DEBUG 0

/*
 * Method: UserPostbacks::new
 */
UserPostbacks::UserPostbacks()
{
	postbacks=new Hash();
	postbacks->add_ref();
}

/*
 * Method: UserPostbacks::delete
 */
UserPostbacks::~UserPostbacks()
{
	postbacks->del_ref();
/*	for (map<string,UserPostback*>::iterator iter1=postbacks.begin();iter1!=postbacks.end();iter1++) {
		if (iter1->second) delete iter1->second;
	}*/
}


/*
 * Method: UserPostbacks::send
 */
bool UserPostbacks::send(Tracker *tr,Array *a)
{
	const char *str1=tr->foreign_clickid;
	const char *str2=tr->aff_sub;
	int i;
	for (i=0;i<a->size;i++) {
		// TODO send http postback
		Blob *b=dynamic_cast<Blob*>(a->get(i));
		if (!b) {
			reject("POSTBACK ERRROR %d_%d_%d offer_id=%d b==NULL\n",tr->clickid_entryno,tr->clickid_fileno,tr->clickid_nodeno,tr->offer_id);
			continue;
		}
		const char *str3=(const char*)b->text;
		if (!str1) str1="";
		if (!str2) str2="";
		if (!str3) str3="";
		printf("NEEDPOSTBACK\t%d_%d_%d\t%d\t%s\t%s\t%f\t%d\t%s\n",tr->clickid_entryno,tr->clickid_fileno,tr->clickid_nodeno,tr->offer_id,str1,str2,tr->payout_db_aff,tr->currency_db_id,str3);
		reject("NEEDPOSTBACK\t%d_%d_%d\t%d\t%s\t%s\t%f\t%d\t%s\n",tr->clickid_entryno,tr->clickid_fileno,tr->clickid_nodeno,tr->offer_id,str1,str2,tr->payout_db_aff,tr->currency_db_id,str3);
	}
	return true;
}

/*
 * Method: UserPostbacks::send
 */
bool UserPostbacks::send(Tracker *tr)
{
	int i;
	Blob *blb;
	if (!postbacks->size) {
		if (DEBUG>1) printf("UserPostbacks::send() - no postbacks\n");
		return false;
	}
	if (!tr->aff_pb) {
		if (DEBUG>1) printf("UserPostbacks::send() - no aff_pb\n");
		return send(tr,dynamic_cast<Array*>(postbacks->values[0]));
	}
	if (tr->aff_pb[0]==0) {
		if (DEBUG>1) printf("UserPostbacks::send() - empty aff_pb\n");
		return send(tr,dynamic_cast<Array*>(postbacks->values[0]));
	}
	BlobPtr *b=new BlobPtr(tr->aff_pb,strlen(tr->aff_pb));
	Array *a=dynamic_cast<Array*>(postbacks->get(b));
	delete b;
	if (!a) {
		if (DEBUG>1) {
			printf("UserPostbacks::send() - no postbacks->[tr->aff_pb]\n");
			printf("UserPostbacks::send() - tr->aff_pb='%s'\n",tr->aff_pb);
			for (i=0;i<postbacks->size;i++) {
				blb=dynamic_cast<Blob*>(postbacks->keys[i]);
				printf("postbacks[%d] key='%s'\n",i,blb?(const char*)blb->text:"null");
			}
		}
		return send(tr,dynamic_cast<Array*>(postbacks->values[0]));
	}
	if (DEBUG>1) printf("UserPostbacks::send() - has postbacks->[tr->aff_pb]\n");
	return send(tr,a);
}

/*
 * Method: UserPostbacks::load
 */
bool UserPostbacks::load(ReadStream *s)
{

}

/*
 * Method: UserPostbacks::save
 */
bool UserPostbacks::save(WriteStream *s)
{

}

/*
 * Method: UserPostbacks::add
 */
void UserPostbacks::add(const char *code,const char *url)
{
	Blob *b=new Blob(code,strlen(code));
	b->add_ref();
	Array *a=dynamic_cast<Array*>(postbacks->get(b));
	if (!a) {
		a=new Array();
		postbacks->put(b,a);
	}
	a->push(new Blob(url,strlen(url)+1));
	b->del_ref();
}

const char *UserPostbacks::classname(void) { return "UserPostbacks"; };


